#include <ESP8266WiFi.h>
#include <BlynkSimpleEsp8266.h>
#include <TimeLib.h>
#include <WidgetRTC.h>
#include <Servo.h>
#include <NewPing.h>

char auth[] = "YourAuthToken";
char ssid[] = "YourNetworkName";
char pass[] = "YourPassword";

#define SERVO_PIN D0
#define INT_LED D4
#define US_TRIGGER D8
#define US_ECHO D7
#define US_MAXDIST 50

BlynkTimer timer;
WidgetRTC rtc;
Servo servo;

int rowIndex = 0;
int feedTimer = 0;
int feedTimeOut = 24;
boolean isEating = false;

NewPing sonar(US_TRIGGER, US_ECHO, US_MAXDIST);

void recordFeed()
{
  Serial.println("recordFeed");
  String currentDateTime = String(hour()) + ":" + minute() + ":" + second() + " " + day() + "/" + month() + "/" + year();
  Blynk.virtualWrite(V2, "add", rowIndex, currentDateTime, "Feeding");
  Blynk.virtualWrite(V2, "pick", rowIndex);
  rowIndex++;
}

void stopFeed()
{
  Serial.println("stopfeed");
  digitalWrite(INT_LED, HIGH);
  servo.write(180);
}

void startFeed()
{
  Serial.println("startfeed");
  recordFeed();
  digitalWrite(INT_LED, LOW);
  servo.write(0);
  timer.setTimeout(2*1000, stopFeed);
}

void checkFeedTime() {
  feedTimer++;
  Serial.print("checkFeedTime: ");
  Serial.println(feedTimer);
  if (feedTimer >= feedTimeOut && feedTimeOut > 0) {
    feedTimer = 0;
    startFeed();
  }
}

void checkPet() {
  int distanceInCm = sonar.ping_cm();

  Serial.print("checkPet : ");
  Serial.println(distanceInCm);
  if (distanceInCm > 0 and distanceInCm < 20) {
    if (isEating == false) {
      isEating = true;
      String currentDateTime = String(hour()) + ":" + minute() + ":" + second() + " " + day() + "/" + month() + "/" + year();
      Blynk.virtualWrite(V2, "add", rowIndex, currentDateTime, "Eating"); 
      Blynk.virtualWrite(V2, "pick", rowIndex);
      rowIndex++;
    }
  } else {
    isEating = false;
  }
  Blynk.virtualWrite(V3, distanceInCm);
}

BLYNK_WRITE(V0)
{
  if (param.asInt() == 1){
    startFeed();
  }
}

BLYNK_WRITE(V1)
{
  feedTimeOut = param.asInt();
  Serial.print("feedTimeOut : ");
  Serial.println(feedTimeOut);
}

BLYNK_CONNECTED() {
  rtc.begin();
}

void setup()
{
  Serial.begin(115200);
  
  servo.attach(SERVO_PIN);
  servo.write(180);

  pinMode(INT_LED, OUTPUT);
  digitalWrite(INT_LED, HIGH);

  Blynk.begin(auth, ssid, pass);
  setSyncInterval(10 * 60);

  Blynk.virtualWrite(V2, "clr");
  Blynk.virtualWrite(V1, 24);

  timer.setInterval(10*1000, checkFeedTime);
  timer.setInterval(2*1000, checkPet);
}

void loop()
{
  Blynk.run();
  timer.run();
} 
