/*
 * Basic Timer and Push
 */

#include <ESP8266WiFi.h>
#include <BlynkSimpleEsp8266.h>

// You should get Auth Token in the Blynk App.
// Go to the Project Settings (nut icon).
char auth[] = "YourAuthToken";

// Your WiFi credentials.
// Set password to "" for open networks.
char ssid[] = "YourNetworkName";
char pass[] = "YourPassword";

BlynkTimer timer;

void stopWater()
{
  digitalWrite(D0, LOW);
}

void startWater()
{
  digitalWrite(D0, HIGH);
  timer.setTimeout(5*1000, stopWater);
}

void setup()
{
  Blynk.begin(auth, ssid, pass);
  pinMode(D0, OUTPUT);
  timer.setInterval(60*1000, startWater);
}

void loop()
{
  Blynk.run();
  timer.run();
}
